/*
 * Decompiled with CFR 0.152.
 */
import geotransform.coords.Gcc_Coord_3d;
import org.web3d.geovrml.GeoVRML;
import vrml.field.MFString;
import vrml.field.SFBool;
import vrml.field.SFNode;
import vrml.field.SFRotation;
import vrml.field.SFString;
import vrml.field.SFVec3f;
import vrml.node.Node;
import vrml.node.Script;

public class GeoLocation
extends Script {
    public void initialize() {
        GeoVRML geoVRML;
        SFNode sFNode = (SFNode)this.getField("geoOrigin");
        MFString mFString = (MFString)this.getField("geoSystem");
        SFString sFString = (SFString)this.getField("geoCoords");
        Node node = (Node)((SFNode)this.getField("transform")).getValue();
        boolean bl = ((SFBool)this.getField("debug")).getValue();
        if (bl) {
            System.out.println("GeoLocation:");
        }
        try {
            geoVRML = new GeoVRML();
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            System.out.println("GeoTransform classes not installed in CLASSPATH!");
            return;
        }
        geoVRML.setOrigin(sFNode);
        Gcc_Coord_3d gcc_Coord_3d = geoVRML.getCoord(sFString, mFString);
        SFVec3f sFVec3f = (SFVec3f)node.getExposedField("translation");
        sFVec3f.setValue((float)gcc_Coord_3d.x, (float)gcc_Coord_3d.y, (float)gcc_Coord_3d.z);
        if (bl) {
            System.out.println("  translation = " + gcc_Coord_3d.x + " " + gcc_Coord_3d.y + " " + gcc_Coord_3d.z);
        }
        float[] fArray = new float[4];
        geoVRML.getLocalOrientation(gcc_Coord_3d, fArray);
        SFRotation sFRotation = (SFRotation)node.getExposedField("rotation");
        sFRotation.setValue(fArray[0], fArray[1], fArray[2], fArray[3]);
        if (bl) {
            System.out.println("  rotation = " + fArray[0] + " " + fArray[1] + " " + fArray[2] + " " + fArray[3] + " (" + fArray[3] * 57.29578f + " deg)");
        }
        SFVec3f sFVec3f2 = (SFVec3f)node.getExposedField("scale");
        float f = (float)(1.0 / geoVRML.scaleFactor);
        sFVec3f2.setValue(f, f, f);
    }
}

