/*
 * Decompiled with CFR 0.152.
 */
import org.web3d.geovrml.GeoVRML;
import vrml.BaseNode;
import vrml.Browser;
import vrml.Event;
import vrml.InvalidVRMLSyntaxException;
import vrml.field.ConstMFNode;
import vrml.field.ConstSFBool;
import vrml.field.MFNode;
import vrml.field.MFString;
import vrml.field.SFBool;
import vrml.field.SFFloat;
import vrml.field.SFInt32;
import vrml.field.SFNode;
import vrml.field.SFString;
import vrml.field.SFVec3f;
import vrml.node.Node;
import vrml.node.Script;

public class GeoLOD
extends Script {
    private MFNode parentNode;
    private float range;
    private SFNode children;
    private SFNode switch_node;
    private Node prox_node;
    private Node lores_node;
    private Node hires_node;
    private boolean debug;
    private MFString[] url = new MFString[5];
    private boolean[] loaded = new boolean[5];
    private boolean[] isloading = new boolean[5];
    private int selected;
    private Browser browser;

    public synchronized void initiate_load(int n) {
        if (n == 0 && this.loaded[0]) {
            this.setSelected(0);
            this.unloadChildren();
            this.children.setValue(this.switch_node);
            if (this.debug) {
                System.out.println("Switch to cached parent nodes");
                return;
            }
        } else if (n == 0 && this.parentNode.getSize() != 0) {
            MFNode mFNode = (MFNode)this.lores_node.getEventIn("addChildren");
            mFNode.setValue(this.parentNode);
            this.loaded[0] = true;
            this.children.setValue(this.switch_node);
            if (this.debug) {
                System.out.println("Setting parentNode for url[0]");
                return;
            }
        } else {
            if (this.browser == null) {
                System.out.println("Browser object not found: cannot load url");
                return;
            }
            int n2 = this.url[n].getSize();
            if (n2 == 0) {
                if (this.debug) {
                    System.out.println("url " + n + " empty");
                }
                return;
            }
            String[] stringArray = new String[this.url[n].getSize()];
            this.url[n].getValue(stringArray);
            try {
                this.browser.createVrmlFromURL(stringArray, (BaseNode)this, "nodesLoaded" + n);
            }
            catch (InvalidVRMLSyntaxException invalidVRMLSyntaxException) {
                System.out.println("Couldn't Inline file: invalid VRML syntax");
                return;
            }
            this.isloading[n] = true;
            if (this.debug) {
                System.out.println("Loading " + stringArray[0]);
            }
        }
    }

    public void initialize() {
        SFBool sFBool;
        Object object;
        this.parentNode = (MFNode)this.getField("parentNode");
        this.url[0] = (MFString)this.getField("parentUrl");
        this.url[1] = (MFString)this.getField("child1Url");
        this.url[2] = (MFString)this.getField("child2Url");
        this.url[3] = (MFString)this.getField("child3Url");
        this.url[4] = (MFString)this.getField("child4Url");
        this.range = ((SFFloat)this.getField("range")).getValue();
        SFNode sFNode = (SFNode)this.getField("geoOrigin");
        MFString mFString = (MFString)this.getField("geoSystem");
        SFString sFString = (SFString)this.getField("center");
        this.switch_node = (SFNode)this.getField("switch_node");
        this.prox_node = (Node)((SFNode)this.getField("prox_node")).getValue();
        this.lores_node = (Node)((SFNode)this.getField("lores_node")).getValue();
        this.hires_node = (Node)((SFNode)this.getField("hires_node")).getValue();
        this.children = (SFNode)this.getEventOut("children");
        this.debug = ((SFBool)this.getField("debug")).getValue();
        int n = 0;
        while (n < 5) {
            this.loaded[n] = false;
            this.isloading[n] = false;
            ++n;
        }
        if (this.debug) {
            System.out.println("range = " + this.range);
        }
        this.range *= 2.0f;
        if (sFString.getValue().length() > 0) {
            GeoVRML geoVRML;
            try {
                geoVRML = new GeoVRML();
            }
            catch (NoClassDefFoundError noClassDefFoundError) {
                System.out.println("GeoVRML classes not installed in CLASSPATH!");
                return;
            }
            geoVRML.setOrigin(sFNode);
            object = geoVRML.getCoord(sFString, mFString);
            if (this.debug) {
                System.out.println("center = " + object.x + ", " + object.y + ", " + object.z);
            }
            sFBool = (SFVec3f)this.prox_node.getExposedField("center");
            sFBool.setValue((float)object.x, (float)object.y, (float)object.z);
        }
        object = (SFVec3f)this.prox_node.getExposedField("size");
        object.setValue(this.range, this.range, this.range);
        sFBool = (SFBool)this.prox_node.getExposedField("enabled");
        sFBool.setValue(true);
        this.browser = this.getBrowser();
        this.initiate_load(0);
    }

    public void setSelected(int n) {
        if (n == this.selected) {
            return;
        }
        Node node = (Node)this.switch_node.getValue();
        SFInt32 sFInt32 = (SFInt32)node.getExposedField("whichChoice");
        sFInt32.setValue(n);
        this.selected = n;
    }

    public synchronized void nodesLoaded(ConstMFNode constMFNode, int n) {
        if (this.debug) {
            System.out.println("Event received: nodesLoaded" + n);
        }
        this.loaded[n] = true;
        this.isloading[n] = false;
        if (n == 0) {
            MFNode mFNode = (MFNode)this.lores_node.getEventIn("addChildren");
            mFNode.setValue(constMFNode);
            this.setSelected(0);
            this.children.setValue(this.switch_node);
            this.unloadChildren();
            return;
        }
        MFNode mFNode = (MFNode)this.hires_node.getEventIn("addChildren");
        mFNode.setValue(constMFNode);
        if (this.loaded[1] && this.loaded[2] && this.loaded[3] && this.loaded[4]) {
            this.setSelected(1);
            this.children.setValue(this.switch_node);
        }
    }

    public synchronized void unloadNodes(Node node) {
        MFNode mFNode = (MFNode)node.getExposedField("children");
        if (mFNode.getSize() == 0) {
            return;
        }
        MFNode mFNode2 = (MFNode)node.getEventIn("removeChildren");
        mFNode2.setValue(mFNode);
    }

    public void unloadParent() {
        this.unloadNodes(this.lores_node);
        this.loaded[0] = false;
    }

    public void unloadChildren() {
        this.unloadNodes(this.hires_node);
        this.loaded[1] = false;
        this.loaded[2] = false;
        this.loaded[3] = false;
        this.loaded[4] = false;
    }

    public synchronized void shutdown() {
        this.unloadParent();
        this.unloadChildren();
    }

    public synchronized void processEvent(Event event) {
        String string = event.getName();
        if (string.equals("isActive")) {
            boolean bl = ((ConstSFBool)event.getValue()).getValue();
            if (bl) {
                int n = 1;
                while (n <= 4) {
                    if (!this.loaded[n] && !this.isloading[n]) {
                        this.initiate_load(n);
                    }
                    ++n;
                }
                return;
            }
            this.initiate_load(0);
            return;
        }
        if (string.equals("nodesLoaded0")) {
            this.nodesLoaded((ConstMFNode)event.getValue(), 0);
            return;
        }
        if (string.equals("nodesLoaded1")) {
            this.nodesLoaded((ConstMFNode)event.getValue(), 1);
            return;
        }
        if (string.equals("nodesLoaded2")) {
            this.nodesLoaded((ConstMFNode)event.getValue(), 2);
            return;
        }
        if (string.equals("nodesLoaded3")) {
            this.nodesLoaded((ConstMFNode)event.getValue(), 3);
            return;
        }
        if (string.equals("nodesLoaded4")) {
            this.nodesLoaded((ConstMFNode)event.getValue(), 4);
        }
    }
}

