/*
 * Decompiled with CFR 0.152.
 */
import vrml.BaseNode;
import vrml.Browser;
import vrml.Event;
import vrml.InvalidVRMLSyntaxException;
import vrml.field.ConstMFNode;
import vrml.field.ConstMFString;
import vrml.field.ConstSFBool;
import vrml.field.MFNode;
import vrml.field.MFString;
import vrml.field.SFBool;
import vrml.field.SFNode;
import vrml.node.Node;
import vrml.node.Script;

public class GeoInline
extends Script {
    private Node group;
    private MFNode children;
    private MFString url_changed;
    private SFBool load_changed;
    private MFNode empty_node;
    private String[] url;
    private boolean load;
    private boolean debug;
    private Browser browser;
    private boolean isloading = false;

    public synchronized void initiate_load() {
        if (this.browser != null) {
            try {
                this.browser.createVrmlFromURL(this.url, (BaseNode)this, "nodesLoaded");
            }
            catch (InvalidVRMLSyntaxException invalidVRMLSyntaxException) {
                System.out.println("Couldn't Inline file: invalid VRML syntax");
                return;
            }
            this.isloading = true;
            if (this.debug) {
                System.out.println("Loading " + this.url[0]);
                return;
            }
        } else {
            System.out.println("Browser object not found");
        }
    }

    public void initialize() {
        this.group = (Node)((SFNode)this.getField("group")).getValue();
        this.children = (MFNode)this.getEventOut("children");
        MFString mFString = (MFString)this.getField("geourl");
        this.url_changed = (MFString)this.getEventOut("url_changed");
        this.load = ((SFBool)this.getField("load")).getValue();
        this.load_changed = (SFBool)this.getEventOut("load_changed");
        this.debug = ((SFBool)this.getField("debug")).getValue();
        this.url = new String[mFString.getSize()];
        mFString.getValue(this.url);
        this.empty_node = new MFNode();
        this.browser = this.getBrowser();
        this.children.setValue(this.empty_node);
        this.url_changed.setValue(this.url);
        this.load_changed.setValue(this.load);
        if (this.load) {
            this.initiate_load();
        }
    }

    public void loadUrl() {
        if (!this.load && !this.isloading) {
            this.initiate_load();
        }
    }

    public void unloadUrl() {
        if (this.load) {
            MFNode mFNode = (MFNode)this.group.getEventIn("removeChildren");
            mFNode.setValue((ConstMFNode)this.group.getEventOut("children"));
            this.children.setValue(this.empty_node);
            this.load = false;
            this.load_changed.setValue(false);
            if (this.debug) {
                System.out.println("Unloading " + this.url[0]);
            }
        }
    }

    public void shutdown() {
        this.unloadUrl();
    }

    public synchronized void processEvent(Event event) {
        String string = event.getName();
        if (string.equals("set_load")) {
            boolean bl = ((ConstSFBool)event.getValue()).getValue();
            if (this.load != bl) {
                if (bl) {
                    this.loadUrl();
                    return;
                }
                this.unloadUrl();
                return;
            }
        } else {
            if (string.equals("set_url")) {
                ConstMFString constMFString = (ConstMFString)event.getValue();
                String[] stringArray = new String[constMFString.getSize()];
                constMFString.getValue(stringArray);
                if (this.load) {
                    this.unloadUrl();
                    this.url = stringArray;
                    this.loadUrl();
                } else {
                    this.url = stringArray;
                }
                this.url_changed.setValue(stringArray);
                return;
            }
            if (string.equals("nodesLoaded")) {
                ConstMFNode constMFNode = (ConstMFNode)event.getValue();
                MFNode mFNode = (MFNode)this.group.getEventIn("addChildren");
                mFNode.setValue(constMFNode);
                this.children.setValue(constMFNode);
                this.load = true;
                this.isloading = false;
                this.load_changed.setValue(true);
            }
        }
    }
}

